using System;

namespace Implab {
    public struct ResolvedPromise<T> : IPromise<T> {
        T m_result;

        public Type ResultType => typeof(T);

        public bool IsResolved => true;

        public bool IsRejected => false;

        public bool IsFulfilled => true;

        public Exception RejectReason => null;

        public ResolvedPromise(T result) {
            m_result = result;
        }

        public IPromise<T2> Cast<T2>() {
            return (IPromise<T2>)(IPromise<T>)this;
        }

        void IPromise.Join() {
        }

        void IPromise.Join(int timeout) {
        }

        public T Join() {
            return m_result;
        }

        public T Join(int timeout) {
            return m_result;
        }

        public void Then(IResolvable<T> next) {
            next.Resolve(m_result);
        }

        public void Then(IResolvable next) {
            next.Resolve();
        }
    }
}